using System;
using System.Runtime.InteropServices;
using System.Text;

namespace Sony
{
	namespace NP
	{
		public class Facebook
		{
			[StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 0)]
			public struct PostFacebook
			{
				public long appID;
				public string userText;
				public string photoURL;
				public string photoTitle;
				public string photoCaption;
				public string photoDescription;
				public string actionLinkName;
				public string actionLinkURL;
			};

			[DllImport("UnityNpToolkit")]
			private static extern bool PrxFacebookIsBusy();

			[DllImport("UnityNpToolkit", CharSet = CharSet.Ansi)]
			private static extern ErrorCode PrxFacebookPostMessage(ref PostFacebook message);
			
			[DllImport("UnityNpToolkit")]
			private static extern bool PrxFacebookGetLastError(out ResultCode result);
			
			public static bool GetLastError(out ResultCode result)
			{
				PrxFacebookGetLastError(out result);
				return result.lastError == ErrorCode.NP_OK;
			}

			public static bool IsBusy()
			{
				return PrxFacebookIsBusy();
			}

			static public ErrorCode PostMessage(PostFacebook message)
			{
				return PrxFacebookPostMessage(ref message);
			}

			public static event Messages.EventHandler OnFacebookDialogStarted;
			public static event Messages.EventHandler OnFacebookDialogFinished;
			public static event Messages.EventHandler OnFacebookMessagePosted;
			public static event Messages.EventHandler OnFacebookMessagePostFailed;

			public static bool ProcessMessage(Messages.PluginMessage msg)
			{
				switch (msg.type)
				{
					case Messages.MessageType.kNPToolKit_FacebookDialogStarted:
						if (OnFacebookDialogStarted != null) OnFacebookDialogStarted(msg);
						return true;
					case Messages.MessageType.kNPToolKit_FacebookDialogFinished:
						if (OnFacebookDialogFinished != null) OnFacebookDialogFinished(msg);
						return true;
					case Messages.MessageType.kNPToolKit_FacebookMessagePosted:
						if (OnFacebookMessagePosted != null) OnFacebookMessagePosted(msg);
						return true;
					case Messages.MessageType.kNPToolKit_FacebookMessagePostFailed:
						if (OnFacebookMessagePostFailed != null) OnFacebookMessagePostFailed(msg);
						return true;
				}
				
				return false;
			}
		}
	}
}
